<?php
/**
 * BwTransifex Component
 *
 * BwTransifex language template for the component frontend
 *
 * BwTransifex is a largely reworked fork of Jonathan Daniel Dimitrov´s cTransifex package
 *
 * @version 1.0.1
 * @package BwTransifex
 * @subpackage BwTransifex Component Site
 * @author Romana Boldt
 * @copyright (C) 2025 Boldt Webservice <forum@boldt-webservice.de>
 * @support https://www.boldt-webservice.de/en/forum-en/forum/bwtransifex.html
 * @license GNU/GPL, see LICENSE.txt
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

use BoldtWebservice\Component\BwTransifex\Administrator\Helper\BwTransifexHelperLanguage;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;

defined('_JEXEC') or die('Restricted access');

// Get provided style file
$wa  = Factory::getApplication()->getDocument()->getWebAssetManager();

$wa->useStyle('com_bwtransifex.bwtransifex_site');

$language = $this->bwtx_language;

if ($this->error) { ?>
    <div class="row-fluid bwtransifex-margin">
        <div data-test="bwtx-error" class="bwtx-error">
            <?php
            $message = '<span class="bwtx-error-text">' . Text::_('COM_BWTRANSIFEX_LANGUAGE_RESOURCE_NOT_FOUND') . '</span>';
            if ($this->error === 'projectNotFound') {
                $message = '<span class="bwtx-error-text">' . Text::_('COM_BWTRANSIFEX_LANGUAGE_PROJECT_NOT_FOUND') . '</span>';
            }
            ?>
            <p><strong><?php echo Text::_('COM_BWTRANSIFEX_LAYOUT_ERROR_HAS_OCCURRED_WHILE_PROCESSING_YOUR_REQUEST'); echo ' ' . $message; ?></strong></p>
            <p><?php echo Text::_('JERROR_LAYOUT_NOT_ABLE_TO_VISIT'); ?></p>
            <ul>
                <li><?php echo Text::_('JERROR_LAYOUT_AN_OUT_OF_DATE_BOOKMARK_FAVOURITE'); ?></li>
                <li><?php echo Text::_('JERROR_LAYOUT_MIS_TYPED_ADDRESS'); ?></li>
                <li><?php echo Text::_('JERROR_LAYOUT_SEARCH_ENGINE_OUT_OF_DATE_LISTING'); ?></li>
                <li><?php echo Text::_('JERROR_LAYOUT_YOU_HAVE_NO_ACCESS_TO_THIS_PAGE'); ?></li>
            </ul>
            <p><?php echo Text::_('COM_BWTRANSIFEX_GO_TO_PROJECTS_LIST'); ?></p>
            <p><a href="<?php echo $this->baseurl; ?>index.php?option=com_bwtransifex&view=projects" class="btn btn-secondary"><span class="icon-home" aria-hidden="true"></span> <?php echo Text::_('COM_BWTRANSIFEX_LAYOUT_PROJECTS_LIST'); ?></a></p>
            <hr>
            <p><?php echo Text::_('JERROR_LAYOUT_PLEASE_CONTACT_THE_SYSTEM_ADMINISTRATOR'); ?></p>
        </div>
    </div>
<?php }
else
{
    $langParts      = explode('-', $language->lang_name);
    $langName       = BwTransifexHelperLanguage::code2ToName($langParts[0]);
    $langCountry    = BwTransifexHelperLanguage::code2ToCountry($langParts[1]);
    $contributeLink = "https://explore.transifex.com/boldt-webservice/" . $this->project->transifex_slug;
    ?>
    <h2 data-test="language-header"><?php echo $this->project->title; ?> - <?php echo ucfirst($langName) ?> (<?php echo ucfirst($langCountry); ?>)</h2>
    <div class="row-fluid bwtransifex-margin">
        <p data-test="language-desc">
            <?php echo Text::sprintf('COM_BWTRANSIFEX_LANGUAGE_COMPLETE_AT', $language->completed); ?>
        </p>

        <div class="progress progress-striped" style="margin-bottom: 0;">
            <div class="bar" style="width: <?php echo $language->completed; ?>%;" data-test="language-progress"></div>
        </div>
    </div>

    <div class="row-fluid bwtransifex-margin">
        <div class="form-actions bwtransifex">
            <?php if($language->completed) : ?>
                <a class="btn btn-default" href="<?php echo Route::_('index.php?option=com_bwtransifex&task=download.download&bwlanguage=' . $language->id); ?>" data-test="language-download">
                    <?php echo Text::_('COM_BWTRANSIFEX_DOWNLOAD_NOW'); ?>
                </a>
            <?php else: ?>
                <div class="alert alert-error">
                    <?php echo Text::_('COM_BWTRANSIFEX_NO_PACKAGE_YET'); ?>
                </div>
            <?php endif; ?>
            <?php if ($this->project->params['display_contribute_link']) : ?>
                <a href="<?php echo $contributeLink; ?>"
                        class="btn btn-default" target="_blank" data-test="language-contribute">
                    <?php echo Text::_('COM_BWTRANSIFEX_HELP_IMPROVE_THIS_LANGUAGE_PACK'); ?>
                </a>
            <?php endif; ?>
        </div>
    </div>

    <?php if (isset($this->project->params['contributor_info']) && $this->project->params['contributor_info'] !== '') : ?>
        <div class="row-fluid">
            <div class="alert" data-test="language-contributor-info">
                <h4><?php echo Text::_('COM_BWTRANSIFEX_CONTRIBUTE_HEADING'); ?></h4>
                <?php echo Text::_($this->project->params['contributor_info']); ?>
            </div>
        </div>
    <?php endif; ?>
    <div class="row-fluid">
        <h3 data-test="language-header-resources">
            <?php echo Text::_('COM_BWTRANSIFEX_CONTAINS_FOLLOWING_RESOURCES'); ?>
        </h3>
        <table class="table">
            <?php foreach ($this->resources as $resource) : ?>
                <tr>
                    <td data-test="language-resource-name-<?php echo $resource->resource_name; ?>">
                        <?php echo $resource->resource_name; ?>
                    </td>
                    <td class="progress-col">
                        <div class="progress progress-striped" style="margin-bottom: 0;">
                            <div class="bar" style="width: <?php echo $resource->completed; ?>%;" data-test="language-resource-progress-<?php echo $resource->resource_name; ?>"></div>
                        </div>
                    </td>
                    <td>
                        <div>
                            <?php if ($this->project->params['display_contribute_link']) : ?>
                                <a href="<?php echo $contributeLink; ?>"
                                        class="btn" target="_blank" data-test="language-resource-contribute-<?php echo $resource->resource_name; ?>">
                                    <?php echo Text::_('COM_BWTRANSIFEX_CONTRIBUTE_NOW'); ?>
                                </a>
                            <?php endif; ?>
                        </div>
                    </td>
                </tr>
            <?php endforeach; ?>
        </table>
    </div>
<?php }

echo LayoutHelper::render('footer', array(), JPATH_SITE . '/components/com_bwtransifex/layouts/footer'); ?>
