<?php
/**
 * BwTransifex Component
 *
 * BwTransifex HTML view langauge class for the component frontend
 *
 * @version 1.0.1
 * @package BwTransifex
 * @subpackage BwTransifex Component Site
 * @author Romana Boldt
 * @copyright (C) 2025 Boldt Webservice <forum@boldt-webservice.de>
 * @support https://www.boldt-webservice.de/en/forum-en/forum/bwtransifex.html
 * @license GNU/GPL, see LICENSE.txt
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

namespace BoldtWebservice\Component\BwTransifex\Site\View\Language;

// No direct access
defined('_JEXEC') or die('Restricted access');

use Exception;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\Registry\Registry;

/**
 * Define the BwTransifex language view class
 *
 * @package 	BwTransifex Site
 *
 * @since 1.0.0
 */
class HtmlView extends BaseHtmlView
{
    /**
     * Display the edit view
     *
     * @throws Exception
     *
     * @since 1.0.0
     */
    public function display($tpl = null)
    {
        // Display the form
        $app          = Factory::getApplication();
        $id           = $app->input->getInt('project', 0);
        $params       = ComponentHelper::getParams('com_bwtransifex', true);
        $menuParams   = new Registry();
        $menu         = $app->getMenu()->getActive();
        $projectTitle = '';

        if ($menu)
        {
            $menuParams->loadString($menu->getParams());
        }

//		$mergedParams = clone $menuParams;
//		$params->merge($mergedParams, true);

        $this->params     = $params;
        $this->menuParams = $menuParams;
        $projectModel     = Factory::getApplication()
            ->bootComponent('com_bwtransifex')
            ->getMVCFactory()
            ->createModel('Project', 'Site');
        $this->project       = $projectModel->getItem($id);
        $model = $this->getModel();
        $this->bwtx_language = $model->getItem();
        $this->resources     = $model->getResources();
        $this->error         = '';

        // Set document title
        $document     = Factory::getApplication()->getDocument();

        if (!property_exists($this->project, 'title')) {
            $projectTitle = Text::_('COM_BWTRANSIFEX_LANGUAGE_PROJECT_NOT_FOUND');
            $this->error = 'projectNotFound';
        }
        elseif (!property_exists($this->bwtx_language, 'lang_name')) {
            $projectTitle = Text::_('COM_BWTRANSIFEX_LANGUAGE_RESOURCE_NOT_FOUND');
            $this->error = 'languageNotFound';
        }

        if (!$this->error) {
            $projectTitle = Text::sprintf('COM_BWTRANSIFEX_LANGUAGE_PACK', $this->bwtx_language->lang_name, $this->project->title);
        }

        $document->setTitle($projectTitle);

        parent::display($tpl);

        return $this;
    }
}
