<?php
/**
 * BwTransifex Component
 *
 * BwTransifex template 'project' for the component backend
 *
 * @version 1.0.1
 * @package BwTransifex
 * @subpackage BwTransifex Component Admin
 * @author Romana Boldt
 * @copyright (C) 2025 Boldt Webservice <forum@boldt-webservice.de>
 * @support https://www.boldt-webservice.de/en/forum-en/forum/bwtransifex.html
 * @license GNU/GPL, see LICENSE.txt
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

// No direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;

// Load the tooltip behavior for the notes
/** @var Joomla\CMS\WebAsset\WebAssetManager $wa */
$wa = $this->document->getWebAssetManager();
$wa->useScript('keepalive')
    ->useScript('form.validate');
HTMLHelper::_('bootstrap.popover', '.hasPopover', array('placement' => 'bottom'));

$detailText = Text::_('COM_BWTRANSIFEX_PROJECT_' . ((int) $this->item->id === 0 ? 'NEW' : 'EDIT'), true);
?>

<div id="bwp_editform">
    <form action="<?php echo Route::_('index.php?option=com_bwtransifex&layout=edit&id=' . (int)$this->item->id); ?>"
        method="post" name="adminForm" id="item-form" aria-label="<?php echo $detailText; ?>" class="form-validate" data-test="edit-form">
        <div class="main-card">
            <?php
            echo HTMLHelper::_('uitab.startTabSet', 'project_tabs', ['active' => 'details', 'recall' => true, 'breakpoint' => 768]);

            echo HTMLHelper::_('uitab.addTab', 'project_tabs', 'details', Text::_('COM_BWTRANSIFEX_PROJECT_DETAILS'));
            ?>
            <div class="card card-body mb-3">
                <div class="row">
                    <div class="col-lg-8">
                        <fieldset class="form-vertical">
                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="control-group">
                                        <div class="control-label" data-test="title-label">
                                            <?php echo $this->form->getLabel('title'); ?>
                                        </div>
                                        <div class="controls" data-test="title-input">
                                            <?php echo $this->form->getInput('title'); ?>
                                        </div>
                                        <?php if ($this->form->getField('title')->description) : ?>
                                            <div class="form-text hide-aware-inline-help d-none" id="<?php echo $this->form->getField('title')->id ?>-desc" data-test="title-desc">
                                                <?php echo Text::_($this->form->getField('title')->description) ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="control-group">
                                        <div class="control-label" data-test="alias-label">
                                            <?php echo $this->form->getLabel('alias'); ?>
                                        </div>
                                        <div class="controls" data-test="alias-input">
                                            <?php echo $this->form->getInput('alias'); ?>
                                        </div>
                                        <?php if ($this->form->getField('alias')->description) : ?>
                                            <div class="form-text hide-aware-inline-help d-none" id="<?php echo $this->form->getField('title')->id ?>-desc" data-test="alias-desc">
                                                <?php echo Text::_($this->form->getField('alias')->description) ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="control-group">
                                <div class="control-label" data-test="desc-label">
                                    <?php echo $this->form->getLabel('description'); ?>
                                    <?php if ($this->form->getField('description')->description) : ?>
                                        <div class="form-text hide-aware-inline-help d-none" id="<?php echo $this->form->getField('title')->id ?>-desc" data-test="desc-desc">
                                            <?php echo Text::_($this->form->getField('description')->description) ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="controls" data-test="desc-input">
                                    <?php echo $this->form->getInput('description'); ?>
                                </div>
                            </div>
                        </fieldset>
                    </div>
                    <div class="col-lg-4 form-vertical">
                        <div class="control-group">
                            <div class="control-label" data-test="published-label">
                                <?php echo $this->form->getLabel('published'); ?>
                            </div>
                            <div class="controls" data-test="published-input">
                                <?php echo $this->form->getInput('published'); ?>
                            </div>
                            <?php if ($this->form->getField('published')->description) : ?>
                                <div class="form-text hide-aware-inline-help d-none" id="<?php echo $this->form->getField('published')->id ?>-desc" data-test="published-desc">
                                    <?php echo Text::_($this->form->getField('published')->description) ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="control-group">
                            <div class="control-label" data-test="access-label">
                                <?php echo $this->form->getLabel('access'); ?>
                            </div>
                            <div class="controls" data-test="access-input">
                                <?php echo $this->form->getInput('access'); ?>
                            </div>
                            <?php if ($this->form->getField('access')->description) : ?>
                                <div class="form-text hide-aware-inline-help d-none" id="<?php echo $this->form->getField('access')->id ?>-desc" data-test="access-desc">
                                    <?php echo Text::_($this->form->getField('access')->description) ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php echo $this->form->getInput('asset_id'); ?>
                </div>
            </div>
            <?php
            echo HTMLHelper::_('uitab.endTab');

            echo HTMLHelper::_('uitab.addTab', 'project_tabs', 'tx_settings', Text::_('COM_BWTRANSIFEX_TRANSIFEX_DETAILS'));
            ?>
            <div class="card card-body mb-3 options-form">
                <div class="row">
                    <div class="col-lg-8">
                        <fieldset class="form-horizontal">
                            <?php foreach ($this->form->getFieldset('transifex') as $field) : ?>
                                <div class="row form-horizontal">
                                    <div class="control-group">
                                        <div class="control-label" data-test="<?php echo $field->fieldname ?>-label">
                                            <?php echo $field->label; ?>
                                            <?php if ($field->fieldname === 'transifex_config'): ?>
                                                <?php if ($field->description) : ?>
                                                    <div class="form-text hide-aware-inline-help d-none" id="<?php echo $field->id ?>-desc" data-test="<?php echo $field->fieldname ?>-desc">
                                                        <?php echo Text::_($field->description) ?>
                                                    </div>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </div>
                                        <div class="controls" data-test="<?php echo $field->fieldname ?>-input">
                                            <?php echo $field->input; ?>
                                            <?php if ($field->fieldname !== 'transifex_config'): ?>
                                                <?php if ($field->description) : ?>
                                                    <div class="form-text hide-aware-inline-help d-none" id="<?php echo $field->id ?>-desc" data-test="<?php echo $field->fieldname ?>-desc">
                                                        <?php echo Text::_($field->description) ?>
                                                    </div>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </fieldset>
                    </div>
                    <?php
                    $fieldSets = $this->form->getFieldsets('params');
                    foreach ($fieldSets as $name => $fieldSet) :
                        if ($name === 'jbasic') { ?>
                        <div class="col-lg-4">
                            <fieldset class="form-vertical">
                                <div class="row">
                                    <?php foreach ($this->form->getFieldset($name) as $field) : ?>
                                        <div class="mb-3">
                                            <div  data-test="<?php echo $field->fieldname ?>-label">
                                                <?php echo $field->label; ?>
                                            </div>
                                            <div  data-test="<?php echo $field->fieldname ?>-input">
                                                <?php echo $field->input; ?>
                                            </div>
                                            <?php if ($field->description) : ?>
                                                <div class="form-text hide-aware-inline-help d-none" id="<?php echo $field->id ?>-desc" data-test="<?php echo $field->fieldname ?>-desc">
                                                    <?php echo Text::_($field->description) ?>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </fieldset>
                        </div>
                    <?php }
                    endforeach; ?>
                </div>
            </div>

            <?php
            echo HTMLHelper::_('uitab.endTab');
            echo HTMLHelper::_('uitab.addTab', 'project_tabs', 'publishing', Text::_('JGLOBAL_FIELDSET_PUBLISHING'));
            ?>
            <div>
                <div class="card card-body mb-3">
                    <div class="row">
                            <fieldset class="form-horizontal options-form">
                                <div class="row">
                                    <div class="col-lg-12">
                                    <?php foreach ($this->form->getFieldset('publish') as $field) : ?>
                                        <div class="control-group">
                                            <div class="control-label" data-test="<?php echo $field->fieldname ?>-label">
                                                <?php echo $field->label; ?>
                                                <?php if ($field->description) : ?>
                                                    <div class="form-text hide-aware-inline-help d-none" id="<?php echo $field->id ?>-desc" data-test="<?php echo $field->fieldname ?>-desc">
                                                        <?php echo Text::_($field->description) ?>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                            <div class="controls" data-test="<?php echo $field->fieldname ?>-input">
                                                <?php echo $field->input; ?>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                    </div>
                                </div>
                            </fieldset>
                    </div>
                </div>
            </div>
            <?php
            echo HTMLHelper::_('uitab.endTab');

            echo HTMLHelper::_('uitab.addTab', 'project_tabs', 'advanced', Text::_('COM_BWTRANSIFEX_ADVANCED_FIELDSET_LABEL'));
            ?>
            <div>
                <div class="card card-body mb-3">
                    <div class="row">
                        <?php
                        $fieldSets = $this->form->getFieldsets('params');
                        foreach ($fieldSets as $name => $fieldSet) :
                            if ($name === 'advanced') { ?>
                            <div class="col-lg-6">
                                <fieldset class="form-horizontal">
                                    <div class="row">
                                        <?php foreach ($this->form->getFieldset($name) as $field) : ?>
                                            <div class="control-group">
                                                <div class="control-label" data-test="<?php echo $field->fieldname ?>-label">
                                                    <?php echo $field->label; ?>
                                                </div>
                                                <div class="controls" data-test="<?php echo $field->fieldname ?>-input">
                                                    <?php echo $field->input; ?>
                                                </div>
                                                <?php if ($field->description) : ?>
                                                    <div class="form-text hide-aware-inline-help d-none" id="<?php echo $field->id ?>-desc" data-test="<?php echo $field->fieldname ?>-desc">
                                                        <?php echo Text::_($field->description) ?>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </fieldset>
                            </div>
                        <?php }
                        endforeach; ?>
                    </div>
                </div>
            </div>
            <?php
            echo HTMLHelper::_('uitab.endTab');

            //            if ($this->permissions['com']['admin'] || $this->permissions['admin']['project'])
//            {
//                echo HTMLHelper::_('uitab.addTab', 'project_tabs', 'rules', Text::_('COM_BWTRANSIFEX_PROJECT_FIELDSET_RULES'));
//                ?>
<!--                <div class="card card-body mb-3 com_config">-->
<!--                    --><?php //echo $this->form->getInput('rules'); ?>
<!--                </div>-->
<!--                --><?php
//                echo HTMLHelper::_('uitab.endTab');
//            }
            echo HTMLHelper::_('uitab.endTabSet');
            ?>
        </div>

        <input type="hidden" name="task" value="" />
        <input type="hidden" name="id" value="<?php echo $this->item->id; ?>" />

        <?php echo HTMLHelper::_('form.token'); ?>
    </form>
</div>
<?php
$displayData = ['view' => $this->item, 'projectUrl' => $this->project_url];
echo LayoutHelper::render('footer', $displayData, JPATH_ADMINISTRATOR . '/components/com_bwtransifex/layouts/footer'); ?>

