CREATE TABLE IF NOT EXISTS `#__bwtransifex_languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) NOT NULL COMMENT 'Project the entry refers to',
  `resource_id` int(11) NOT NULL COMMENT 'Resource the entry refers to',
  `lang_name` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Language name',
  `completed` float(5) NOT NULL COMMENT 'Current translation state',
  `raw_data` longtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Holds translation state and raw stats data',
  PRIMARY KEY (`id`)
) ENGINE=INNODB DEFAULT CHARSET=utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT 'Holds translation state and raw stats data per project and resource';

CREATE TABLE IF NOT EXISTS `#__bwtransifex_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) NOT NULL DEFAULT 0,
  `title` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Project title',
  `transifex_slug` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Project slug at transifex.com',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Used for SEF',
  `published` tinyint(1) NOT NULL DEFAULT 0,
  `created_time` datetime DEFAULT NULL,
  `created_by` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `created_by_alias` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '??',
  `modified_time` datetime DEFAULT NULL,
  `modified_by` int(11) UNSIGNED NOT NULL DEFAULT 0,
  `modified_by_alias` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '??',
  `ordering` int(11) NOT NULL DEFAULT 0,
  `access` int(11) NOT NULL DEFAULT 0,
  `transifex_config` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'configuration for transifex.com',
  `extension_name` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Used for manifest of language package',
  `params` longtext COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=INNODB DEFAULT CHARSET=utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT 'Holds project data';

CREATE TABLE IF NOT EXISTS `#__bwtransifex_resources` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) NOT NULL DEFAULT 0 COMMENT 'Project the entry refers to',
  `resource_name` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Resource name tof he entry',
  PRIMARY KEY (`id`)
) ENGINE=INNODB DEFAULT CHARSET=utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT 'Holds resource names per project';

CREATE TABLE IF NOT EXISTS `#__bwtransifex_zips` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` int(11) NOT NULL DEFAULT 0 COMMENT 'Project the entry refers to',
  `lang_name` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Language the entry refers to',
  `completed` float(5) NOT NULL DEFAULT 0 COMMENT 'Current overall translation state',
  `created_time` datetime DEFAULT NULL,
  `lang_version` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Project version the entry belongs to',
  PRIMARY KEY (`id`)
) ENGINE=INNODB DEFAULT CHARSET=utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT 'Holds translation state and version of current language packages per project and language';
