<?php
/**
 * BwTransifex Component
 *
 * BwTransifex HTML view list class for the component frontend
 *
 * @version 1.0.1
 * @package BwTransifex
 * @subpackage BwTransifex Component Site
 * @author Romana Boldt
 * @copyright (C) 2025 Boldt Webservice <forum@boldt-webservice.de>
 * @support https://www.boldt-webservice.de/en/forum-en/forum/bwtransifex.html
 * @license GNU/GPL, see LICENSE.txt
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

namespace BoldtWebservice\Component\BwTransifex\Site\View\Projects;

// No direct access
defined('_JEXEC') or die('Restricted access');

use Exception;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\Registry\Registry;

/**
 * Define the BwTransifex projects view class
 *
 * @package 	BwTransifex Site
 *
 * @since 1.0.0
 */
class HtmlView extends BaseHtmlView
{
    /**
     * Display the lists view
     *
     * @param   null  $tpl  The name of the template file to parse; automatically searches through the template paths.
     *
     * @throws Exception
     *
     * @since 1.0.0
     */
    public function display($tpl = null)
    {
        $params     = ComponentHelper::getParams('com_bwtransifex', true);
        $menuParams = new Registry;
        $menu       = Factory::getApplication()->getMenu()->getActive();

        if ($menu)
        {
            $menuParams->loadString($menu->getParams());
        }

//		$mergedParams = clone $menuParams;
//		$params->merge($mergedParams, true);

        $this->params = $params;
        $model        = $this->getModel();

        $this->state = $model->getState();
        $this->items = $model->getItems();
        $this->filterForm		= $model->getFilterForm();
        $this->activeFilters	= $model->getActiveFilters();
        $this->pagination		= $model->getPagination();
        $this->total			= $model->getTotal();

        $document     = Factory::getApplication()->getDocument();
        $projectTitle = Text::_('COM_BWTRANSIFEX_VIEW_PROJECTS_LIST_TITLE');
        $document->setTitle($projectTitle);

        parent::display($tpl);

        return $this;
    }
}
