<?php
/**
 * BwTransifex Component
 *
 * BwTransifex template 'projects' for the component backend
 *
 * @version 1.0.1
 * @package BwTransifex
 * @subpackage BwTransifex Component Admin
 * @author Romana Boldt
 * @copyright (C) 2025 Boldt Webservice <forum@boldt-webservice.de>
 * @support https://www.boldt-webservice.de/en/forum-en/forum/bwtransifex.html
 * @license GNU/GPL, see LICENSE.txt
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

// No direct access
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Uri\Uri;

HTMLHelper::_('bootstrap.modal', '.selector', []);
/** @var \Joomla\CMS\WebAsset\WebAssetManager $wa */
$wa = $this->document->getWebAssetManager();
$wa->useScript('table.columns');
$wa->useScript('multiselect');
$wa->useScript('keepalive')
    ->useScript('form.validate');

if (!empty($this->items))
{
    $wa->useScript('com_bwtransifex.projects');
    $wa->useStyle('com_bwtransifex.bwtransifex_admin');
}

Text::script('COM_BWTRANSIFEX_ERROR_NO_SESSION_STORAGE');
Text::script('COM_BWTRANSIFEX_RESOURCES_FETCH');
Text::script('COM_BWTRANSIFEX_RESOURCES_FOUND');
Text::script('COM_BWTRANSIFEX_LANGSTATS_FETCH');
Text::script('COM_BWTRANSIFEX_LANGSTATS_FOUND');
Text::script('COM_BWTRANSIFEX_LANGPACK_FETCH');
Text::script('COM_BWTRANSIFEX_LANGPACK_LANG');
Text::script('COM_BWTRANSIFEX_LANGPACK_CREATE');
Text::script('COM_BWTRANSIFEX_LANGPACK_FINALIZATION');
Text::script('COM_BWTRANSIFEX_LANGPACK_FINALIZATION_ERROR');
Text::script('COM_BWTRANSIFEX_MODAL_ERROR_HEADING');
Text::script('COM_BWTRANSIFEX_MODAL_ERROR_STATUS');
Text::script('COM_BWTRANSIFEX_MODAL_ERROR_CODE');
Text::script('COM_BWTRANSIFEX_MODAL_ERROR_TITLE');
Text::script('COM_BWTRANSIFEX_MODAL_ERROR_DETAIL');

$action = Route::_('index.php?option=com_bwtransifex&task=projectjson.resources&format=json&project-id=');

$this->document->addScriptOptions(
    'bwtx_project_refresh',
    [
        'baseUrl' => Uri::root(),
        'token' => Session::getFormToken(),
        'action' => $action,
    ]
);

$user      = Factory::getApplication()->getIdentity();
$config    = ComponentHelper::getParams('com_bwtransifex');
$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn  = $this->escape($this->state->get('list.direction'));
?>
<div class="bw-bootstrap">
    <?php if(!BWTRANSIFEX_PRO) : ?>
        <div class="alert alert-info bwtx_style_test" data-test="subscription-message">
            <?php echo Text::sprintf('COM_BWTRANSIFEX_GET_SUB_FOR_PRO_PROJECTS', 'https://www.boldt-webservice.de/subscriptions/levels'); ?>
        </div>
    <?php endif; ?>
    <div>
        <form action="<?php echo Route::_('index.php?option=com_bwtransifex&view=projects'); ?>"
                id="adminForm"
                name="adminForm"
                method="POST"
                data-test="list-form">
        <div class="row">
            <div class="col-md-12">
                <div id="j-main-container" class="j-main-container">
                    <?php
                    // Search tools bar
                    echo LayoutHelper::render('joomla.searchtools.default', ['view' => $this]);
                    ?>
                    <?php if (empty($this->items)) : ?>
                        <div class="alert alert-info" data-test="empty-list">
                            <span class="icon-info-circle" aria-hidden="true"></span><span class="visually-hidden"><?php echo Text::_('INFO'); ?></span>
                            <?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
                        </div>
                    <?php else : ?>
                        <table class="table table-striped adminlist" id="com_bwtransifex_list" data-test="list-table">
                            <caption class="visually-hidden" data-test="list-caption">
                                <?php echo Text::_('COM_BWTRANSIFEX_PROJECT_TABLE_CAPTION'); ?>,
                                <span id="orderedBy"><?php echo Text::_('JGLOBAL_SORTED_BY'); ?> </span>,
                                <span id="filteredBy"><?php echo Text::_('JGLOBAL_FILTERED_BY'); ?></span>
                            </caption>
                            <thead data-test="list-header">
                            <tr>
                                <th class="w-1 text-center" data-test="list-header-checkall">
                                    <?php echo HTMLHelper::_('grid.checkall'); ?>
                                </th>
                                <th scope="col" class="w-10 text-center" data-test="list-header-status">
                                    <?php echo HTMLHelper::_('searchtools.sort', 'JSTATUS', 'p.published', $listDirn, $listOrder); ?>
                                </th>
                                <th scope="col" data-test="list-header-title">
                                    <?php echo HTMLHelper::_('searchtools.sort', 'JGLOBAL_TITLE', 'p.title', $listDirn, $listOrder); ?>
                                </th>
                                <th data-test="list-header-access">
                                    <?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ACCESS', 'p.access', $listDirn, $listOrder); ?>
                                </th>
                                <th scope="col" class="w-5 d-none d-md-table-cell" data-test="list-header-id">
                                    <?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ID', 'p.id', $listDirn, $listOrder); ?>
                                </th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php foreach ($this->items as $i => $item) :
                                $ordering  = ($listOrder == 'ordering');
                                $canCreate  = $user->authorise('core.create', 'com_bwtransifex.' . $item->id);
                                $canEdit    = $user->authorise('core.edit', 'com_bwtransifex.' . $item->id);
                                $canCheckin = $user->authorise('core.manage', 'com_checkin') || $item->checked_out == $user->id || is_null($item->checked_out);
                                $canChange  = $user->authorise('core.edit.state', 'com_bwtransifex.' . $item->id) && $canCheckin;
                                $titleText  = Text::_('COM_BWTRANSIFEX_LOAD_TRANSIFEX_PROJECT_DATA');
                                $linkText   = Route::_('index.php?option=com_bwtransifex&view=project&format=raw&layout=newsletter_text_modal&task=insideModal&project_id=' . $item->id);
                                ?>
                                <tr class="row<?php echo $i % 2; ?>" data-test="list-row">
                                    <td class="text-center" data-test="list-row-check">
                                        <?php echo HTMLHelper::_('grid.id', $i, $item->id, false, 'cid', 'cb', $item->title); ?>
                                    </td>
                                    <td class="text-center">
                                        <?php if ($config->get('tx_username') && $config->get('tx_password')) : ?>
                                            <a class="btn btn-info btn-sm text-decoration-none mt-1 select-link" href="javascript:void(0);"
                                                    data-id="<?php echo $item->id; ?>"
                                                    title="<?php echo $titleText;?>"
                                                    data-title="<?php echo $titleText;?>"
                                                    data-bs-title="<?php echo $titleText;?>"
                                                    data-bs-toggle="modal"
                                                    data-bs-target="#bwtransifex-project-data"
                                                    data-toggle="bwtransifex"
                                                    data-test="list-row-action">
                                                <span class="fas fa-sync" aria-hidden="true"></span>
                                            </a>
                                        <?php endif; ?>
                                        <span data-test="list-row-publish">
                                            <?php echo HTMLHelper::_('jgrid.published', $item->published, $i, 'projects.', $canChange, 'cb'); ?>
                                        </span>
                                    </td>
                                    <td data-test="list-row-title">
                                        <div class="break-word">
                                            <a href="<?php echo Route::_('index.php?option=com_bwtransifex&task=project.edit&id=' . $item->id); ?>"
                                                    title="<?php echo Text::_('JACTION_EDIT'); ?>" data-test="list-row-title-link">
                                                <?php echo $item->title; ?>
                                            </a>
                                        </div>
                                    </td>
                                    <td class="small hidden-phone" data-test="list-row-access">
                                        <?php echo $this->escape($item->access_level); ?>
                                    </td>
                                    <td class="d-none d-md-table-cell" data-test="list-row-id">
                                        <?php echo $item->id; ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>

                        <?php // Load the pagination. ?>
                        <?php echo $this->pagination->getListFooter(); ?>

                        <?php // Load the batch processing form. ?>
                        <?php
                        if (
                            $user->authorise('core.create', 'com_bwtransifex')
                            && $user->authorise('core.edit', 'com_bwtransifex')
                            && $user->authorise('core.edit.state', 'com_bwtransifex')
                        ) : ?>
                            <div class="modal" id="bwtransifex-project-data" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false" data-test="project-modal">
                                <div class="modal-dialog modal-xl" data-test="project-modal-dialog">
                                    <div class="modal-content" data-test="project-modal-content">
                                        <div class="modal-header" data-test="project-modal-header">
                                            <h3 id="myModalLabel" class="modal-title text-center" data-test="project-modal-heading"><?php echo Text::_('COM_BWTRANSIFEX_FETCH_DATA_FROM_TRANSIFEX_FOR_THIS_PROJECT'); ?></h3>
                                            <button type="button" class="btn-close bw_action_buttons" data-bs-dismiss="modal" aria-label="<?php echo Text::_('JTOOLBAR_CLOSE'); ?>" data-test="project-modal-header-close"></button>
                                        </div>
                                        <div class="modal-body p-3" data-test="project-modal-body">
                                            <div data-test="project-modal-body-intro"><?php echo Text::_('COM_BWTRANSIFEX_SIT_BACK_RELAX'); ?></div>

                                            <div id="bwtx_message_container-outer" data-test="project-modal-body-message-outer">
                                            </div>
                                            <form></form>
                                            <form action="<?php echo $action; ?>" method="POST" id="modalForm" name="modalForm" class="bwtransifex-project-data-form" data-test="project-modal-body-form">
                                                <input type="hidden" id="bw_form_action" value="<?php echo $action; ?>" data-test="project-modal-body-form-action" />
                                                <input type="hidden" id="token" value="<?php echo Session::getFormToken(); ?>" data-test="project-modal-body-form-token" />
                                                <input type="hidden" id="baseUrl" value="<?php echo Uri::root(); ?>" data-test="project-modal-body-form-base-url" />
                                            </form>
                                        </div>
                                        <div class="modal-footer" data-test="project-modal-footer">
                                            <button type="button" class="btn btn-secondary bw_action_buttons" data-bs-dismiss="modal" aria-hidden="true" data-test="project-modal-footer-close">
                                                <?php echo Text::_('COM_BWTRANSIFEX_CLOSE'); ?>
                                            </button>
                                            <button id="bw_action" type="button" class="btn btn-primary bw_action_buttons" data-test="project-modal-footer-action"><?php echo Text::_('COM_BWTRANSIFEX_GET_DATA'); ?></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>

                    <input type="hidden" name="task" value="" data-test="list-form-task">
                    <input type="hidden" name="boxchecked" value="0" data-test="list-form-boxchecked">
                    <?php echo HTMLHelper::_('form.token'); ?>
                </div>
            </div>
        </div>
    </form>
    </div>
<?php echo LayoutHelper::render('footer', ['view' => $this->items, 'projectUrl' => $this->project_url], JPATH_ADMINISTRATOR . '/components/com_bwtransifex/layouts/footer'); ?>
