<?php
/**
 * BwTransifex Component
 *
 * BwTransifex HTML view list class for the component backend
 *
 * @version 1.0.1
 * @package BwTransifex
 * @subpackage BwTransifex Component Admin
 * @author Romana Boldt
 * @copyright (C) 2025 Boldt Webservice <forum@boldt-webservice.de>
 * @support https://www.boldt-webservice.de/en/forum-en/forum/bwtransifex.html
 * @license GNU/GPL, see LICENSE.txt
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

namespace BoldtWebservice\Component\BwTransifex\Administrator\View\Projects;

// No direct access
defined('_JEXEC') or die('Restricted access');

use Exception;
use Joomla\CMS\Factory;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Pagination\Pagination;
use Joomla\CMS\Toolbar\ToolbarFactoryInterface;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\Component\Content\Administrator\Extension\ContentComponent;

/**
 * Define the BwTransifex HTML projects view class
 *
 * @package BwTransifex Admin
 *
 * @since 1.0.0
 */
class HtmlView extends BaseHtmlView
{
    /**
     * An array of items
     *
     * @var  array
     *
     * @since 1.0.0
     */
    protected array $items;

    /**
     * The pagination object
     *
     * @var  Pagination
     *
     * @since 1.0.0
     */
    protected Pagination $pagination;

    /**
     * The model state
     *
     * @var   object
     *
     * @since 1.0.0
     */
    protected object $state;

    /**
     * Form object for search filters
     *
     * @var  Form
     *
     * @since 1.0.0
     */
    public Form $filterForm;

    /**
     * The active search filters
     *
     * @var  array
     *
     * @since 1.0.0
     */
    public array $activeFilters;

    /**
     * All transition, which can be executed of one if the items
     * ???
     * @var  array
     *
     * @since 1.0.0
     */
    protected array $transitions = [];

    /**
     * Is this view an Empty State
     *
     * @var   boolean
     *
     * @since 1.0.0
     */
    private bool $isEmptyState = false;

    /**
     * The URL of the project BwTransifex
     *
     * @var   string
     *
     * @since 1.0.0
     */
//	@ToDo: Specify this url
    public string $project_url = 'https://www.boldt-webservice.de/';

    /**
     * Execute and display a template script.
     *
     * @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
     *
     * @return  HtmlView  A string if successful, otherwise a JError object.
     *
     * @throws Exception
     *
     * @since 1.0.0
     */
    public function display($tpl = null): HtmlView
    {
        $model = $this->getModel();
        $this->items			= $model->getItems();
        $this->pagination		= $model->getPagination();
        $this->state            = $model->getState();
        $this->filterForm		= $model->getFilterForm();
        $this->activeFilters	= $model->getActiveFilters();

        $this->addToolbar();

        $document     = Factory::getApplication()->getDocument();
        $projectTitle = Text::_('COM_BWTRANSIFEX_VIEW_PROJECTS_LIST_TITLE');
//		$document->setTitle($projectTitle);

        // Call parent display
        parent::display($tpl);
        return $this;
    }

    /**
     * Add toolbar
     *
     * @throws Exception
     *
     * @since 1.0.0
     */
    protected function addToolbar(): void
    {
        $user      = Factory::getApplication()->getIdentity();

        // Get the toolbar object instance
        $toolbar = Factory::getContainer()->get(ToolbarFactoryInterface::class)->createToolbar()->getInstance();

        // Set toolbar title
        ToolbarHelper::title(Text::_('COM_BWTRANSIFEX_PROJECTS'), 'list');

        // Set toolbar items for the page
        $canCreate  = $user->authorise('core.create', 'com_bwtransifex');
        $canEdit    = $user->authorise('core.edit', 'com_bwtransifex');
        $canCheckin = $user->authorise('core.manage', 'com_checkin');
        $canManage  = $user->authorise('core.admin', 'com_bwtransifex');
        $canDelete  = $user->authorise('core.delete', 'com_bwtransifex');

        if ($canCreate)
        {
            $toolbar->addNew('project.add');
        }

        if ($canEdit)
        {
            $dropdown = $toolbar->dropdownButton('status-group')
                ->text('JTOOLBAR_CHANGE_STATUS')
                ->toggleSplit(false)
                ->icon('fa fa-ellipsis-h')
                ->buttonClass('btn btn-action')
                ->listCheck(true);

            $childBar = $dropdown->getChildToolbar();

            $childBar->edit('project.edit')->listCheck(true);
            $childBar->publish('projects.publish')->listCheck(true);
            $childBar->unpublish('projects.unpublish')->listCheck(true);
            $childBar->trash('projects.trash')->listCheck(true);

            if ($canCheckin)
            {
                $childBar->checkin('projects.checkin')->listCheck(true);
            }

            if (!$this->isEmptyState && $this->state->get('filter.published') == ContentComponent::CONDITION_TRASHED && $canDelete)
            {
                $toolbar->delete('projects.delete', 'JTOOLBAR_EMPTY_TRASH')
                    ->message('JGLOBAL_CONFIRM_DELETE')
                    ->listCheck(true);
            }
        }

        if ($canManage)
        {
            $toolbar->preferences('com_bwtransifex');
        }


//		$toolbar->addButtonPath(JPATH_COMPONENT_ADMINISTRATOR . '/libraries/toolbar');
//
//		$manualButton = BwPostmanHTMLHelper::getManualButton('projects');
//		$forumButton  = BwPostmanHTMLHelper::getForumButton();
//
//		$toolbar->appendButton($manualButton);
//		$toolbar->appendButton($forumButton);
    }
}
