<?php
/**
 * BwTransifex Component
 *
 * BwTransifex HTML view details class for the component backend
 *
 * @version 1.0.1
 * @package BwTransifex
 * @subpackage BwTransifex Component Admin
 * @author Romana Boldt
 * @copyright (C) 2025 Boldt Webservice <forum@boldt-webservice.de>
 * @support https://www.boldt-webservice.de/en/forum-en/forum/bwtransifex.html
 * @license GNU/GPL, see LICENSE.txt
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

namespace BoldtWebservice\Component\BwTransifex\Administrator\View\Project;

// No direct access
defined('_JEXEC') or die('Restricted access');

use Exception;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Toolbar\ToolbarHelper;
use stdClass;

/**
 * Define the BwTransifex HTML project view class
 *
 * @package BwTransifex Admin
 *
 * @since 1.0.0
 */
class HtmlView extends BaseHtmlView
{
    /**
     * property to hold form data
     *
     * @var array   $form
     *
     * @since       1.0.0
     */
    protected $form;

    /**
     * property to hold selected item
     *
     * @var stdClass   $item
     *
     * @since       1.0.0
     */
    protected stdClass $item;

    /**
     * property to hold state
     *
     * @var array|object  $state
     *
     * @since       1.0.0
     */
    protected $state;

    /**
     * property to project url
     *
     * @var string $project_url
     *
     * @since       1.0.0
     */
    protected string $project_url = "https://www.boldt-webservice.de/";

    /**
     * Display
     *
     * @param null $tpl - the template
     *
     * @return void
     *
     * @throws Exception
     *
     * @since 1.0.0
     */
    public function display($tpl = null): void
    {
        $model = $this->getModel();
        $this->form  = $model->getForm();
        $this->item  = $model->getItem();
        $this->state = $model->getState();

        $this->addToolbar();

        parent::display();
    }

    /**
     * Add toolbar
     *
     * @return void
     *
     * @throws Exception
     *
     * @since 1.0.0
     */
    private function addToolbar(): void
    {
        $document = Factory::getApplication()->getDocument();
        $isNew    = ($this->item->id == 0);

        if ($isNew)
        {
            ToolBarHelper::title(Text::_('COM_BWTRANSIFEX_PROJECT_NEW'), 'projects');
            $document->setTitle(Text::_('COM_BWTRANSIFEX_PROJECT_NEW'));
        }
        else
        {
            ToolBarHelper::title(Text::_('COM_BWTRANSIFEX_PROJECT_EDIT'), 'projects');
            $document->setTitle(Text::_('COM_BWTRANSIFEX_PROJECT_EDIT'));
        }

        ToolBarHelper::save('project.save');
        ToolBarHelper::apply('project.apply');
        ToolBarHelper::cancel('project.cancel');
        ToolbarHelper::inlinehelp();
    }
}
