<?php
/**
 * BwTransifex Component
 *
 * BwTransifex table class for the component backend
 *
 * @version 1.0.1
 * @package BwTransifex
 * @subpackage BwTransifex Component Admin
 * @author Romana Boldt
 * @copyright (C) 2025 Boldt Webservice <forum@boldt-webservice.de>
 * @support https://www.boldt-webservice.de/en/forum-en/forum/bwtransifex.html
 * @license GNU/GPL, see LICENSE.txt
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

namespace BoldtWebservice\Component\BwTransifex\Administrator\Table;

// No direct access
defined('_JEXEC') or die('Restricted access');

use DateTime;
use Exception;
use Joomla\CMS\Factory;
use Joomla\CMS\Table\Table;
use Joomla\Database\DatabaseDriver;
use Joomla\Filter\InputFilter;

/**
 * Define the BwTransifex zip table class
 *
 * @package BwTransifex Admin
 *
 * @since 1.0.0
 */
class ZipTable extends Table
{
    /**
     * @var int Primary Key
     *
     * @since 1.0.0
     */
    public int $id = 0;

    /**
     * @var int project_id
     *
     * @since 1.0.0
     */
    public int $project_id = 0;

    /**
     * @var int resource_id
     *
     * @since 1.0.0
     */
    public int $resource_id = 0;

    /**
     * @var string lang_name
     *
     * @since 1.0.0
     */
    public string $lang_name = '';

    /**
     * @var float completed
     *
     * @since 1.0.0
     */
    public float $completed = 0;

    /**
     * @var datetime creation date of the project
     *
     * @since 1.0.0
     */
    public $created_date = '0000-00-00 00:00:00';

    /**
     * @var string lang_version
     * text
     *
     * @since 1.0.0
     */
    public string $lang_version = '';

    /**
     * Constructor
     *
     * @param   DatabaseDriver  $db  Database connector object
     *
     * @since 1.0.0
     */
    public function __construct($db)
    {
        parent::__construct('#__bwtransifex_zips', 'id', $db);

        $this->_jsonEncode = ['raw_data'];
    }

    /**
     * Override Table::check method to ensure data integrity
     *
     * @access public
     *
     * @return boolean True
     *
     * @throws Exception
     *
     * @since 1.0.0
     */
    public function check(): bool
    {
        try {
            // Add event
            parent::check();

            // Sanitize values
            $filter = new InputFilter(array(), array(), 0, 0);

            $this->id           = $filter->clean($this->id, 'UINT');
            $this->project_id   = $filter->clean($this->project_id, 'UINT');
            $this->resource_id  = $filter->clean($this->resource_id, 'UINT');
            $this->lang_name    = $filter->clean($this->lang_name, 'STRING');
            $this->completed    = $filter->clean($this->completed, 'FLOAT');
            $this->created_time = $filter->clean($this->created_time);
            $this->lang_version = $filter->clean($this->lang_version, 'STRING');

            return true;
        }
        catch (Exception $exception)
        {
            throw new Exception($exception);
        }
    }

    /**
     * Override Table::store to set created/modified and user id.
     *
     * @param   boolean  $updateNulls  True to update fields even if they are null.
     *
     * @return  boolean  True on success.
     *
     * @throws Exception
     *
     * @since   1.0.0
     */
    public function store($updateNulls = false): bool
    {
        $date = Factory::getDate();

        if (!$this->id)
        {
            // New project
            $this->created_time = $date->toSql();
        }

        return parent::store($updateNulls);
    }
}

