<?php
/**
 * BwTransifex Component
 *
 * BwTransifex defines helper class for the component backend
 *
 * @version 1.0.1
 * @package BwTransifex
 * @subpackage BwTransifex Component Admin
 * @author Romana Boldt
 * @copyright (C) 2025 Boldt Webservice <forum@boldt-webservice.de>
 * @support https://www.boldt-webservice.de/en/forum-en/forum/bwtransifex.html
 * @license GNU/GPL, see LICENSE.txt
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

namespace BoldtWebservice\Component\BwTransifex\Administrator\Helper;

// No direct access
use Exception;
use Joomla\CMS\Log\Log;

defined('_JEXEC') or die('Restricted access');

/**
 * Define the BwTransifex general helper class
 *
 * @package	 BwTransifex Admin
 *
 * @since	 1.0.0
 */
class BwTransifexHelper
{
    /**
     * Log an exception
     *
     * @param Exception $exception
     * @param string    $category
     * @param string    $severity
     * @param string    $preMessage
     *
     * @return void
     *
     * @since 1.0.0
     */
    public static function logException(Exception $exception, string $category, string $severity = Log::NOTICE, string $preMessage = ''): void
    {
        $log_options    = array('text_file' => 'com_bwtransifex.error.php');
        Log::addLogger($log_options);

        $eType = get_class($exception);
        $trace = $exception->getTraceAsString();

        $message = $preMessage;

        if ($preMessage)
        {
            $message .= ' ';
        }

        $message .= $eType . ' ' . $exception->getMessage();
        $message .= ' in file ' . $exception->getFile();
        $message .= ' at line ' . $exception->getLine();
        $message .= ' Trace: ' . $trace;

        Log::add($message, $severity, $category);
    }
}
