<?php
/**
 * BwTransifex Component
 *
 * BwTransifex layout 'footer'
 *
 * @version 1.0.1
 * @package BwTransifex
 * @subpackage BwTransifex Component Admin
 * @author Romana Boldt
 * @copyright (C) 2025 Boldt Webservice <forum@boldt-webservice.de>
 * @support https://www.boldt-webservice.de/en/forum-en/forum/bwtransifex.html
 * @license GNU/GPL, see LICENSE.txt
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Language\Text;

/** @var array $displayData */
if ($displayData)
{
?>

<div class="bwat-footer col-md-12" data-test="list-footer">
    <div class="card card-footer text-center mt-3">
        <p class="bwtx_copyright" data-test="list-footer-version">
            <a href="<?php echo $displayData['projectUrl'] ?>" target="_blank" title="<?php echo Text::_('BWTRANSIFEX_PROJECT_URL_DESCRIPTION'); ?>">
                BwTransifex <?php echo (BWTRANSIFEX_PRO) ? 'PRO' : 'Core'; ?> <?php echo ComponentHelper::getParams('com_bwtransifex')->get('version');
            ?></a>
        </p>
        <p class="bwat-review" data-test="list-footer-review">
            <?php echo Text::_('COM_BWTRANSIFEX_REVIEW_MESSAGE'); ?>
        </p>
        <p style="font-size: x-small" data-test="list-footer-licence">
            BwTransifex is Free software released under the
            <a href="https://www.gnu.org/licenses/gpl.html">GNU General Public License,</a>
            version 2 of the license or &ndash;at your option&ndash; any later version
            published by the Free Software Foundation.
        </p>
        <p style="font-size: x-small;" data-test="list-footer-copyright">
            Copyright &copy;<?php echo date('Y'); ?> Boldt Webservice
        </p>
    </div>
    <?php if(BWTRANSIFEX_PRO) : ?>
        <div class="alert alert-info" data-test="list-footer-subscription">
            <?php echo Text::_('COM_BWTRANSIFEX_THANKYOU_SUBSCRIPTION'); ?>
        </div>
    <?php endif; ?>
    <div class="clr"></div>
</div>
<?php
}
